using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public partial class LABRESULT_CHANGE_TRACKINGDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public LABRESULT_CHANGE_TRACKINGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public LABRESULT_CHANGE_TRACKING GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 LABRESULT_CHANGE_TRACKING_ID)
        {
            LABRESULT_CHANGE_TRACKING objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_LABRESULT_CHANGE_TRACKING_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, LABRESULT_CHANGE_TRACKING_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<LABRESULT_CHANGE_TRACKING> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<LABRESULT_CHANGE_TRACKING> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_LABRESULT_CHANGE_TRACKING_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<LABRESULT_CHANGE_TRACKING> GetItemsByWkfCaseId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID, string SORT_COLUMN, int? START_ROW, int? MAX_ROWS)
        {
            List<LABRESULT_CHANGE_TRACKING> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_LABRESULT_CHANGE_TRACKING_getItemsByWkfCaseId(
                        CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, SORT_COLUMN, START_ROW, MAX_ROWS).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int GetItemsByWkfCaseIdCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            int? objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_LABRESULT_CHANGE_TRACKING_getItemsByWkfCaseIdCount(
                        CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, ref objReturn);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, LABRESULT_CHANGE_TRACKING objSave)
        {
            Int32? objReturn = objSave.LABRESULT_CHANGE_TRACKING_ID;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_LABRESULT_CHANGE_TRACKING_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CHANGE_DATE, objSave.CHANGE_DESCRIPTION, objSave.CHANGE_FIELD, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.NAVIGATION_URL, DateTime.Now, objSave.UPDATEDBY, objSave.WKF_CASE_ID);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 LABRESULT_CHANGE_TRACKING_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_LABRESULT_CHANGE_TRACKING_delete(CURRENT_USER, CURRENT_REGISTRY_ID, LABRESULT_CHANGE_TRACKING_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
